(defun c:pl2pl3 (/ cmd blp)
   (setq cmd (getvar "cmdecho"))
   (setq blp (getvar "blipmode"))
   (setvar "blipmode" 0)
   (setvar "cmdecho" 0)
   (textpage)
   (princ "\n Wellcome to 2D to 3D conversion Utility Program")
   (princ "\n wirrten by Farboud S. Lorestani in N-ARA Co.")
   (seting)
   (2d3d)
   (setvar "blipmode" blp)
   (setvar "cmdecho" cmd)
   (princ)
)

(defun seting()
   (princ "\n")
   (princ "\n")
   (setq lo (strcase (getstring "\nEnter original curve leyer : ")))
   (setq co (strcase (getstring "\nEnter original curve color : ")))
   (princ "\n")
   (setq lt (getstring "\nEnter target curve leyer (Enter for same) : "))
   (if (= lt "") (setq lt lo) (command "layer" "n" lt ""))
   (setq ct (getstring "\nEnter target curve color (Enter for same) : "))
   (if (= ct "") (setq ct co))
   (setq wt (getreal "\nEnter target curve width (Enter for 0): "))
   (if (= wt nil) (setq wt 0))
   (setvar "plinewid" wt)
)

(defun 2d3d()
   (setq s1 (ssget "x" (list (cons 0 "POLYLINE") (cons 8 lo))))
   (setq i 0)
   (repeat (sslength s1)
      (setq listco nil)
      (setq n1 (ssname s1 i))
      (setq n2 (entnext n1) n3 (entget n2))
      (while (/= (cdr (assoc 0 n3)) "SEQEND")
         (setq listco (append listco (list (cdr (assoc 10 n3)))))
         (setq n2 (entnext n2) n3 (entget n2))
      )
      (setq j 1)
      (command "layer" "s" lt "")
      (command "color" ct)
      (setq p0 (trans (nth 0 listco) n1 0))
      (setq p1 (list (car p0) (cadr p0) (atof (rtos (caddr p0) 2 2))))
      (command "pline" p1)
      (repeat (1- (length listco))
         (command (trans (nth j listco) n1 0))
         (setq j (1+ j))
      )
      (command "")
      (command "erase" n1 "")
      (setq i (1+ i))
   )
)
